*********************************************************
* This program uses output from Rage-rgequate to create *
*   graphs like those in Figure 3.4 on page 78 of Kolen *
*   and Brennan (the example data is from the example   *
*   file input.dat).  This program will work with any   *
*   set of C values.  You must indicate the number of C *
*   levels you used and specify the specific C values.  *
*   Paste in your output where indicated.               *
*                                     -Brett Foley      *
*********************************************************;
*********************************************************
* Minor changes have been made from Brett's orignal SAS *
*   codes such that the final codes could be generated  *
*   by Rage-Rgequate automatically.                     *
*                                     -Zhongmin Cui     *
*********************************************************;

*------------------------------------* 
| Enter the number of C levels here. |
*------------------------------------*;
%LET numlevels = 
10
;

*------------------------------------*
| Enter the C values here (separated |
|   by spaces).                      |
*------------------------------------*;
%LET levels = 
1 2 3 4 5 6 7 8 9 10 
;


*-----------------------------------------------------*
| Paste Smoothed distribution Data for Form X (or Y)  |
|   output here. (after "datalines" command)          |
*-----------------------------------------------------*;
data preplots;
input Score Raw c1-c&numlevels Beta; 
datalines;

0          0.0000000 0.0080615 0.0000027 0.0000145 0.0000000 0.0000024 0.0000075 0.0001047 0.0001071 0.0000429 0.0000364 0.0000000
1          0.0000000 0.0081949 0.0000043 0.0000204 0.0000000 0.0000036 0.0000086 0.0000452 0.0000413 0.0000136 0.0000170 0.0000000
2          0.0000000 0.0083305 0.0000069 0.0000285 0.0000001 0.0000054 0.0000105 0.0000266 0.0000228 0.0000073 0.0000109 0.0000000
3          0.0000001 0.0084684 0.0000109 0.0000396 0.0000003 0.0000084 0.0000135 0.0000201 0.0000168 0.0000058 0.0000091 0.0000001
4          0.0000004 0.0086085 0.0000171 0.0000548 0.0000008 0.0000129 0.0000180 0.0000186 0.0000156 0.0000062 0.0000094 0.0000004
5          0.0000013 0.0087509 0.0000263 0.0000755 0.0000020 0.0000200 0.0000248 0.0000201 0.0000172 0.0000080 0.0000114 0.0000013
6          0.0000038 0.0088957 0.0000402 0.0001034 0.0000048 0.0000310 0.0000350 0.0000246 0.0000217 0.0000119 0.0000156 0.0000038
7          0.0000096 0.0090429 0.0000605 0.0001408 0.0000106 0.0000478 0.0000505 0.0000331 0.0000300 0.0000192 0.0000232 0.0000098
8          0.0000220 0.0091926 0.0000899 0.0001907 0.0000220 0.0000732 0.0000737 0.0000475 0.0000444 0.0000325 0.0000367 0.0000224
9          0.0000457 0.0093447 0.0001321 0.0002568 0.0000434 0.0001113 0.0001082 0.0000712 0.0000684 0.0000560 0.0000598 0.0000469
10         0.0000881 0.0094993 0.0001917 0.0003436 0.0000813 0.0001675 0.0001594 0.0001096 0.0001078 0.0000963 0.0000988 0.0000905
11         0.0001587 0.0096565 0.0002749 0.0004569 0.0001451 0.0002491 0.0002342 0.0001707 0.0001711 0.0001630 0.0001628 0.0001633
12         0.0002702 0.0098163 0.0003892 0.0006037 0.0002474 0.0003659 0.0003424 0.0002660 0.0002702 0.0002690 0.0002646 0.0002777
13         0.0004375 0.0099787 0.0005443 0.0007923 0.0004043 0.0005300 0.0004964 0.0004109 0.0004211 0.0004304 0.0004207 0.0004488
14         0.0006781 0.0101438 0.0007519 0.0010326 0.0006350 0.0007564 0.0007117 0.0006251 0.0006435 0.0006663 0.0006513 0.0006935
15         0.0010110 0.0103117 0.0010260 0.0013362 0.0009610 0.0010626 0.0010072 0.0009321 0.0009602 0.0009971 0.0009786 0.0010302
16         0.0014562 0.0104823 0.0013828 0.0017164 0.0014052 0.0014689 0.0014047 0.0013575 0.0013957 0.0014439 0.0014251 0.0014779
17         0.0020336 0.0106558 0.0018409 0.0021882 0.0019900 0.0019970 0.0019280 0.0019274 0.0019740 0.0020265 0.0020121 0.0020553
18         0.0027619 0.0108321 0.0024208 0.0027681 0.0027359 0.0026696 0.0026018 0.0026656 0.0027162 0.0027625 0.0027573 0.0027800
19         0.0036576 0.0110113 0.0031444 0.0034739 0.0036596 0.0035087 0.0034500 0.0035908 0.0036383 0.0036664 0.0036740 0.0036676
20         0.0047336 0.0111935 0.0040342 0.0043241 0.0047727 0.0045342 0.0044935 0.0047145 0.0047503 0.0047488 0.0047706 0.0047307
21         0.0059985 0.0113787 0.0051125 0.0053374 0.0060805 0.0057615 0.0057481 0.0060397 0.0060549 0.0060167 0.0060503 0.0059783
22         0.0074558 0.0115670 0.0063996 0.0065316 0.0075820 0.0072007 0.0072223 0.0075609 0.0075479 0.0074724 0.0075125 0.0074150
23         0.0091031 0.0117584 0.0079126 0.0079229 0.0092691 0.0088543 0.0089160 0.0092651 0.0092197 0.0091138 0.0091526 0.0090406
24         0.0109324 0.0119530 0.0096636 0.0095242 0.0111278 0.0107163 0.0108192 0.0111335 0.0110560 0.0109339 0.0109630 0.0108494
25         0.0129293 0.0121508 0.0116575 0.0113439 0.0131388 0.0127720 0.0129120 0.0131434 0.0130393 0.0129208 0.0129325 0.0128304
26         0.0150740 0.0123518 0.0138906 0.0133842 0.0152781 0.0149976 0.0151657 0.0152705 0.0151501 0.0150570 0.0150466 0.0149667
27         0.0173416 0.0125562 0.0163489 0.0156396 0.0175189 0.0173614 0.0175437 0.0174899 0.0173674 0.0173195 0.0172866 0.0172360
28         0.0197026 0.0127640 0.0190065 0.0180957 0.0198318 0.0198247 0.0200041 0.0197771 0.0196686 0.0196802 0.0196290 0.0196107
29         0.0221237 0.0129752 0.0218255 0.0207276 0.0221862 0.0223441 0.0225017 0.0221082 0.0220296 0.0221060 0.0220447 0.0220582
30         0.0245689 0.0131899 0.0247557 0.0234992 0.0245507 0.0248729 0.0249905 0.0244592 0.0244238 0.0245599 0.0244995 0.0245416
31         0.0270001 0.0134082 0.0277355 0.0263632 0.0268936 0.0273633 0.0274258 0.0268051 0.0268215 0.0270016 0.0269538 0.0270205
32         0.0293779 0.0136300 0.0306935 0.0292611 0.0291829 0.0297685 0.0297653 0.0291189 0.0291896 0.0293892 0.0293640 0.0294514
33         0.0316621 0.0138556 0.0335509 0.0321250 0.0313866 0.0320439 0.0319710 0.0313700 0.0314904 0.0316801 0.0316837 0.0317892
34         0.0338126 0.0140848 0.0362253 0.0348788 0.0334723 0.0341484 0.0340087 0.0335240 0.0336825 0.0338322 0.0338656 0.0339879
35         0.0357895 0.0143179 0.0386338 0.0374417 0.0354070 0.0360451 0.0358486 0.0355418 0.0357206 0.0358051 0.0358634 0.0360016
36         0.0375538 0.0145548 0.0406980 0.0397313 0.0371571 0.0377015 0.0374647 0.0373796 0.0375573 0.0375604 0.0376336 0.0377862
37         0.0390679 0.0147957 0.0423474 0.0416681 0.0386882 0.0390897 0.0388337 0.0389905 0.0391439 0.0390622 0.0391370 0.0392998
38         0.0402959 0.0150405 0.0435240 0.0431793 0.0399651 0.0401858 0.0399345 0.0403255 0.0404336 0.0402773 0.0403396 0.0405045
39         0.0412044 0.0152894 0.0441856 0.0442036 0.0409526 0.0409696 0.0407472 0.0413362 0.0413830 0.0411754 0.0412132 0.0413672
40         0.0417634 0.0155424 0.0443079 0.0446951 0.0416160 0.0414242 0.0412529 0.0419781 0.0419552 0.0417293 0.0417348 0.0418610
41         0.0419476 0.0157995 0.0438865 0.0446261 0.0419224 0.0415356 0.0414329 0.0422132 0.0421220 0.0419149 0.0418868 0.0419658
42         0.0417369 0.0160610 0.0429367 0.0439900 0.0418424 0.0412925 0.0412694 0.0420143 0.0418658 0.0417126 0.0416562 0.0416693
43         0.0411189 0.0163267 0.0414931 0.0428021 0.0413521 0.0406870 0.0407463 0.0413669 0.0411809 0.0411081 0.0410347 0.0409681
44         0.0400897 0.0165969 0.0396070 0.0410988 0.0404355 0.0397147 0.0398506 0.0402720 0.0400742 0.0400947 0.0400191 0.0398676
45         0.0386556 0.0168715 0.0373437 0.0389365 0.0390873 0.0383763 0.0385744 0.0387466 0.0385648 0.0386748 0.0386124 0.0383827
46         0.0368343 0.0171507 0.0347785 0.0363877 0.0373153 0.0366789 0.0369176 0.0368235 0.0366832 0.0368627 0.0368260 0.0365380
47         0.0346561 0.0174345 0.0319929 0.0335377 0.0351428 0.0346378 0.0348907 0.0345498 0.0344699 0.0346858 0.0346816 0.0343675
48         0.0321638 0.0177230 0.0290700 0.0304790 0.0326103 0.0322787 0.0325176 0.0319840 0.0319737 0.0321865 0.0322140 0.0319140
49         0.0294125 0.0180163 0.0260907 0.0273065 0.0297753 0.0296394 0.0298380 0.0291929 0.0292498 0.0294212 0.0294725 0.0292286
50         0.0264681 0.0183144 0.0231299 0.0241122 0.0267120 0.0267709 0.0269089 0.0262477 0.0263585 0.0264596 0.0265213 0.0263695
51         0.0234053 0.0186174 0.0202541 0.0209808 0.0235083 0.0237382 0.0238039 0.0232212 0.0233638 0.0233811 0.0234379 0.0234005
52         0.0203043 0.0189255 0.0175186 0.0179859 0.0202610 0.0206188 0.0206110 0.0201842 0.0203320 0.0202706 0.0203092 0.0203894
53         0.0172472 0.0192387 0.0149670 0.0151871 0.0170703 0.0174998 0.0174279 0.0172043 0.0173311 0.0172127 0.0172257 0.0174061
54         0.0143130 0.0195570 0.0126305 0.0126286 0.0140319 0.0144730 0.0143552 0.0143439 0.0144296 0.0142870 0.0142744 0.0145195
55         0.0115738 0.0198806 0.0105282 0.0103393 0.0112304 0.0116283 0.0114882 0.0116599 0.0116939 0.0115629 0.0115318 0.0117957
56         0.0090899 0.0202096 0.0086684 0.0083326 0.0087325 0.0090458 0.0089074 0.0092026 0.0091864 0.0090959 0.0090579 0.0092944
57         0.0069069 0.0205440 0.0070497 0.0066091 0.0065818 0.0067884 0.0066717 0.0070151 0.0069611 0.0069259 0.0068931 0.0070660
58         0.0050524 0.0208839 0.0056630 0.0051579 0.0047971 0.0048948 0.0048125 0.0051310 0.0050586 0.0050764 0.0050577 0.0051485
59         0.0035356 0.0212295 0.0044934 0.0039600 0.0033723 0.0033765 0.0033325 0.0035717 0.0035018 0.0035553 0.0035533 0.0035644
60         0.0023470 0.0215808 0.0035217 0.0029902 0.0022806 0.0022179 0.0022080 0.0023427 0.0022912 0.0023558 0.0023668 0.0023182
61         0.0014611 0.0219379 0.0027264 0.0022203 0.0014796 0.0013803 0.0013950 0.0014303 0.0014045 0.0014577 0.0014737 0.0013952
62         0.0008391 0.0223009 0.0020848 0.0016209 0.0009183 0.0008095 0.0008375 0.0008011 0.0007984 0.0008277 0.0008408 0.0007612
63         0.0004334 0.0226699 0.0015747 0.0011630 0.0005435 0.0004447 0.0004760 0.0004045 0.0004162 0.0004216 0.0004275 0.0003657
64         0.0001933 0.0230450 0.0011748 0.0008201 0.0003059 0.0002275 0.0002553 0.0001803 0.0001964 0.0001870 0.0001863 0.0001484
65         0.0000690 0.0234264 0.0008657 0.0005682 0.0001631 0.0001076 0.0001287 0.0000693 0.0000828 0.0000695 0.0000661 0.0000475
66         0.0000166 0.0238140 0.0006302 0.0003867 0.0000822 0.0000468 0.0000608 0.0000223 0.0000307 0.0000207 0.0000178 0.0000107
67         0.0000017 0.0242081 0.0004531 0.0002584 0.0000389 0.0000185 0.0000268 0.0000058 0.0000098 0.0000046 0.0000033 0.0000012

;
run;

*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*
!        Do not alter code below this point!      !
*!!!!!!!!!!!!!!!!!!!!DANGER!!!!!!!!!!!!!!!!!!!!!!!*;

*This reformats the data (tall format);
data preplots_reformatted; set preplots;

array testarray1 [&numlevels] c1-c&numlevels;
array x1[&numlevels] y1-y&numlevels (&levels);

do i = 1 to &numlevels;
clevel=i; eqvalue=testarray1[i]; C_Value = x1[i]; output;
end;
keep Score Raw clevel eqvalue C_Value;
run;


**************************
* Formatting for graphs  *
**************************;

*This deletes the contents of the default graphics catalog work.gseg;
proc greplay nofs igout=work.gseg; delete _all_; run; quit;

*This creates axis labels;
axis1 label = (font=swiss height=1 'Raw Score');
axis2 label = (angle=90 font=swiss height=1 'Relative Frequency');

*This sets up legends for the graphs;
legend1 label=none
        shape=symbol(7,1)
        position=(top center inside)
		value=('Smoothed' 'Raw')
        mode=share;


*******************************************
* This prints 1 graph per page (looks best*
*   printed in landscape format)          *
*******************************************;
proc sort; by C_Value; run;

options nobyline;
proc gplot data=preplots_reformatted;
   by C_Value;
   plot eqvalue*Score Raw*Score 
        /overlay haxis=axis1 vaxis=axis2 legend=legend1;
        symbol1 color=red   i=line v=square h=1;
		symbol2 color=black i=line v=diamond h=1;
        title 'Presmoothing Distribution, C = #byval(C_Value)';
run; quit;

proc gplot data=preplots;
   plot Beta*Score Raw*Score 
        /overlay haxis=axis1 vaxis=axis2 legend=legend1;
        symbol1 color=red   i=line v=square h=1;
		symbol2 color=black i=line v=diamond h=1;
        title 'Presmoothing Distribution, Beta4';
run; quit;

*******************************************
* This prints multiple graphs on a single *
*  sheet (4 graphs per page), print in    *
*  landscape format.                      *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup4graphs;
    %if (&numlevels LE 3) %then %do;
        treplay 1:Gplot  2:Gplot1 3:Gplot2 4:Gplot3; 
    %end;
    %else %if (&numlevels LE 7) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2 4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6 4:Gplot7;
	%end;
	%else %if (&numlevels LE 11) %then %do;
        treplay 1:Gplot   2:Gplot1 3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4  2:Gplot5 3:Gplot6  4:Gplot7;
        treplay 1:Gplot8  2:Gplot9 3:Gplot10 4:Gplot11;
    %end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Gplot    2:Gplot1  3:Gplot2  4:Gplot3; 
        treplay 1:Gplot4   2:Gplot5  3:Gplot6  4:Gplot7;
		treplay 1:Gplot8   2:Gplot9  3:Gplot10 4:Gplot11;
		treplay 1:Gplot12  2:Gplot13 3:Gplot14 4:Gplot15;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp1 des='Four per page'
   1/llx=0 lly=51
     ulx=0 uly=100
     urx=49 ury=100
     lrx=49 lry=51
     color=white
   2/llx=51 lly=51
     ulx=51 uly=100
     urx=100 ury=100
     lrx=100 lry=51
     color=white
   3/llx=0 lly=0
     ulx=0 uly=49
     urx=49 ury=49
     lrx=49 lry=0
     color=white
   4/llx=51 lly=0
     ulx=51 uly=49
     urx=100 ury=49
     lrx=100 lry=0
     color=white;

   template= newtemp1;

   %setup4graphs;
run; quit;


*******************************************
* This prints multiple graphs on a single *
*  sheet (8 graphs per page), print in    *
*  portrait format.                       *
*******************************************;

*This makes sure we print the correct number of graphs;
%macro setup8graphs;
    %if (&numlevels LE 7) %then %do;
        treplay 1:Template  2:Templat1;
	%end;
    %else %if (&numlevels LE 11) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2;
	%end;
	%else %if (&numlevels LE 15) %then %do;
        treplay 1:Template  2:Templat1;
		treplay 1:Templat2  2:Templat3;
	%end;
%mend;

*This prints the graphs;
proc greplay igout=work.gseg tc=work.tempcat nofs;
tdef newtemp2 des='Two per page'
   1/llx=0 lly=50.5
     ulx=0 uly=100
     urx=100 ury=100
     lrx=100 lry=50.5
     color=white
   2/llx=0 lly=0
     ulx=0 uly=49.5
     urx=100 ury=49.5
     lrx=100 lry=0
     color=white;

   template = newtemp2;

   %setup8graphs;
run; quit;
run; quit;
